 CC3S.BURST
;
; SET INTERLACE ON FOR BETTER CHARACTERS
; USE <CNTRL>+<ALT> TO TOGGLE
;
; SETUP CODE ORIGIN
; FOR A BASIC LOADER START
;
.ORG $1C00
.OBJ "@0:INTERL"
       VDCADR = $D600 ;8563 ADDRESS REGISTER
       VDCDAT = $D601 ;8563 DATA REGISTER
       PRIMM  = $FF7D ;PRINT IMMEDIATE
       CONT   = $0BC1 ;WHERE VECTOR ADDRESS GOES
       INTCOD = $0BC3 ;WHERE CODE WILL GO
       MAGKEY = $0C ;<CNTRL><ALT>
       KEYVEC = $033A ;WHERE KEYCHECK CODE GOES
       SHFLAG = $D3 ;SHIFT FLAG LOCATION
       TXTTAB = $2D ;START OF BASIC TEXT
;
; BASIC LOADER DATA
;
BEGIN = *
       .BYTE $25,$1C                 ;NEXT BASIC LINE
       .BYTE $0A,$00                 ;LINE NUMBER 10
       .BYTE $FE,$02,$31,$32,$3A     ;BANK 12:
       .BYTE $9E,$28,$C2             ;SYS(PEEK
       .BYTE $28,$34,$36,$29,$AC,$32 ;(46)*2
       .BYTE $35,$36,$AA,$C2,$28,$34 ;56+PEEK(4
       .BYTE $35,$29,$AA,$33,$38,$29 ;5)+38)
       .BYTE $3A,$FE,$02,$31,$35     ;:BANK15
       .BYTE $00                     ;LINE TERMINATOR
       .BYTE $00,$00                 ;NO NEXT LINE
;
; SKIP THE CODE
;
       SEC
       BCS PROPER
;
;**********************************************************
; KEYBOARD WEDGE
;**********************************************************
;
; CHECK FOR KEYPRESSED
;
START  PHA ;SAVE ACCUMULATOR DATA
       TXA ;SAVE X
       PHA
       LDX #END-START-1 ;BOUNCE COUNTER LOCATION
       LDA SHFLAG ;GET SHIFT FLAG DATA
       AND #MAGKEY ;PICK UP ONLY THE REQUIRED BITS
       CMP #MAGKEY ;COMPARE WHETHER ALL BITS SET
       BEQ +
;
;      NO, RESET NUMBER OF HITS
;
       LDA #$04 ;4 HITS BEFORE ACCEPTING
       STA INTCOD,X
-      PLA ;RETURN X, AND USE NORMAL ROUTINE
       TAX
       PLA
       JMP (CONT)
;
; YES, DECREMENT NUMBER OF HITS BEFORE ACTING
;
+      DEC INTCOD,X
       BNE - ;IF NOT ENOUGH, CONTINUE WITH KEYBOARD CHECK
;
;      TOGGLE FROM CURRENT INTERLACE SETTING, SO FIRST GET IT
;
+      LDX #$08 ;SET INTERLACE REGISTER
       STX VDCADR
-      BIT VDCADR ;WAIT FOR O.K. TO READ
       BPL -
       LDA VDCDAT ;GET THE CURRENT VALUE
;
; TOGGLE BIT 0
;
       EOR #$01
;
; AND STORE IT AGAIN
;
       STX VDCADR
-      BIT VDCADR
       BPL -
       STA VDCDAT
;
; RESTORE X AND A
;
       PLA
       TAX
       PLA
       RTS
       .BYTE 0 ;STORAGE FOR NUMBER OF HITS
END =*
;
; STOP INTERRUPTS
;
PROPER SEI
;
; SEND A MESSAGE TO INFORM USER HOW TO USE
;
       JSR PRIMM 
       .BYTE $93,$0D,$0D ;CLEAR SCREEN AND SEND TWO RETURNS
       .ASC "                  80 COLUMN INTERLACE"
       .BYTE $0D
       .ASC "                 FOR CLEARER CHARACTERS"
       .BYTE $0D
       .ASC "            USE <CNTRL>+<ALT> TO TOGGLE ON/OFF"
       .BYTE $0D
       .ASC "           (DARKER COLORS EXHIBIT LESS FLICKER)"
       .BYTE $0D
       .BYTE $00
;
; MOVE THE KEY WATCHING CODE
;
       LDY #END-BEGIN-1
       LDX #END-START-1
-      LDA (TXTTAB),Y
       STA INTCOD,X
       DEY
       DEX
       BPL -
;
; SAVE THE OLD KEYVEC
; (MAKE SURE MULTIPLE CALLS ARE O.K.)
;
       LDA KEYVEC
       CMP <INTCOD
       BEQ +
       STA CONT
+      LDA KEYVEC+1
       CMP >INTCOD
       BEQ +
       STA CONT+1
;
; SET THE NEW KEYVEC
;
+      LDA <INTCOD
       STA KEYVEC
       LDA >INTCOD
       STA KEYVEC+1
;
; SAVE THE MAGIC KEYPRESS SO ROUTINE WORKS FIRST TIME
;
       LDA SHFLAG
       PHA ;SAVE CURRENT FLAG
       LDA #MAGKEY ;SAVE WHAT WE WANT
       STA SHFLAG
;
; TURN ON IMMEDIATELY
;
       LDA #$01
       LDX #END-START-1
       STA INTCOD,X
;
; CALL THE ROUTINE
;
       JSR INTCOD               
;
; AND TIDY UP
;
       PLA
       STA SHFLAG
       CLI
       RTS ;AND END THE SETUP RUN
.END
